<?php
require_once __DIR__ . '/src/bootstrap.php';
$userData = $userObj->getData();

// Helpers for progress
function getPct($val, $max)
{
    if ($max <= 0)
        return 0;
    return min(100, ($val / $max) * 100);
}

$storageUsed = $userData['used_storage'] ?? 0;
$storageLimit = $userData['storage_limit'] ?? 0;
$storagePct = getPct($storageUsed, $storageLimit);

$uploadsUsed = $userData['used_uploads'] ?? 0;
$uploadLimit = $userData['upload_limit'] ?? 0;
$uploadPct = getPct($uploadsUsed, $uploadLimit);

$downloadsUsed = $userData['used_downloads'] ?? 0;
$downloadLimit = $userData['download_limit'] ?? 0;
$downloadPct = getPct($downloadsUsed, $downloadLimit);
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php $pageTitle = 'Usage';
    include 'components/head.php'; ?>
    <style>
        .usage-stat {
            margin-bottom: 2rem;
        }

        .stat-header {
            display: flex;
            justify-content: space-between;
            margin-bottom: 0.5rem;
        }

        .stat-value {
            font-weight: 600;
        }
    </style>
</head>

<body>
    <div class="app-container">
        <?php include 'components/sidebar.php'; ?>

        <div class="main-content">
            <div class="page-header">
                <h2>Usage Statistics</h2>
            </div>

            <div class="card">
                <h3 style="margin-bottom: 2rem;">Resource Consumption</h3>

                <!-- Storage -->
                <div class="usage-stat">
                    <div class="stat-header">
                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                            <i data-feather="hard-drive" style="width: 18px;"></i>
                            <span>Storage Space</span>
                        </div>
                        <span class="stat-value">
                            <?= round($storageUsed / 1024 / 1024, 2) ?> MB /
                            <?= round($storageLimit / 1024 / 1024, 2) ?> MB
                        </span>
                    </div>
                    <div class="progress-bar" style="height: 12px;">
                        <div class="progress-fill" style="width: <?= $storagePct ?>%;"></div>
                    </div>
                    <div class="text-muted" style="margin-top: 0.5rem; font-size: 0.9rem;">
                        You have used <?= round($storagePct, 1) ?>% of your available storage.
                    </div>
                </div>

                <!-- Uploads -->
                <div class="usage-stat">
                    <div class="stat-header">
                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                            <i data-feather="upload-cloud" style="width: 18px;"></i>
                            <span>File Uploads</span>
                        </div>
                        <span class="stat-value">
                            <?= $uploadsUsed ?> / <?= $uploadLimit ?> Files
                        </span>
                    </div>
                    <div class="progress-bar" style="height: 12px;">
                        <div class="progress-fill"
                            style="width: <?= $uploadPct ?>%; background: linear-gradient(90deg, #ec4899, #d946ef);">
                        </div>
                    </div>
                    <div class="text-muted" style="margin-top: 0.5rem; font-size: 0.9rem;">
                        Total number of files uploaded to your account.
                    </div>
                </div>

                <!-- Downloads -->
                <div class="usage-stat">
                    <div class="stat-header">
                        <div style="display: flex; align-items: center; gap: 0.5rem;">
                            <i data-feather="download-cloud" style="width: 18px;"></i>
                            <span>Downloads</span>
                        </div>
                        <span class="stat-value">
                            <?= $downloadsUsed ?> / <?= $downloadLimit ?>
                        </span>
                    </div>
                    <div class="progress-bar" style="height: 12px;">
                        <div class="progress-fill"
                            style="width: <?= $downloadPct ?>%; background: linear-gradient(90deg, #f59e0b, #ea580c);">
                        </div>
                    </div>
                    <div class="text-muted" style="margin-top: 0.5rem; font-size: 0.9rem;">
                        Total file downloads performed.
                    </div>
                </div>

            </div>
        </div>
    </div>
    <script>feather.replace();</script>
</body>

</html>