<?php
require_once __DIR__ . '/src/bootstrap.php';
$userData = $userObj->getData();
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <?php $pageTitle = 'Billing';
    include 'components/head.php'; ?>
</head>

<body>
    <div class="app-container">
        <?php include 'components/sidebar.php'; ?>

        <!-- Main Content -->
        <div class="main-content">
            <div class="page-header">
                <h2>Billing & Packets</h2>
            </div>

            <div class="card">
                <h3>Current Plan</h3>
                <div style="display: flex; align-items: center; gap: 1rem; margin-bottom: 2rem;">
                    <i data-feather="package" style="width: 48px; height: 48px; color: var(--accent-primary)"></i>
                    <div>
                        <div style="font-size: 1.5rem; font-weight: 600; color: white;">
                            <?= htmlspecialchars($userData['package_name'] ?? 'Custom Plan') ?>
                        </div>
                        <div class="text-muted">Active Subscription</div>
                    </div>
                    <div style="margin-left: auto;">
                        <span class="badge"
                            style="background: rgba(16, 185, 129, 0.2); color: #6ee7b7; font-size: 1rem; padding: 0.5rem 1.5rem; border-radius: 99px;">Active</span>
                    </div>
                </div>

                <h4
                    style="margin-bottom: 1rem; color: var(--text-secondary); text-transform: uppercase; letter-spacing: 1px; font-size: 0.8rem;">
                    Plan Limits</h4>
                <div
                    style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem; background: rgba(0,0,0,0.2); padding: 1.5rem; border-radius: 12px; border: 1px solid rgba(255,255,255,0.05);">

                    <!-- Storage Limit -->
                    <div style="text-align: center; border-right: 1px solid rgba(255,255,255,0.1);">
                        <i data-feather="hard-drive" style="color: var(--accent-primary); margin-bottom: 0.5rem;"></i>
                        <div style="font-size: 0.9rem; color: var(--text-secondary);">Storage Limit</div>
                        <div style="font-size: 1.25rem; font-weight: 600; margin-top: 0.25rem;">
                            <?= round(($userData['storage_limit'] ?? 0) / 1024 / 1024 / 1024, 2) ?> GB
                        </div>
                    </div>

                    <!-- Upload Limit -->
                    <div style="text-align: center; border-right: 1px solid rgba(255,255,255,0.1);">
                        <i data-feather="upload-cloud" style="color: #d946ef; margin-bottom: 0.5rem;"></i>
                        <div style="font-size: 0.9rem; color: var(--text-secondary);">Upload Limit</div>
                        <div style="font-size: 1.25rem; font-weight: 600; margin-top: 0.25rem;">
                            <?= number_format($userData['upload_limit'] ?? 0) ?> Files
                        </div>
                    </div>

                    <!-- Download Limit -->
                    <div style="text-align: center;">
                        <i data-feather="download-cloud" style="color: #f97316; margin-bottom: 0.5rem;"></i>
                        <div style="font-size: 0.9rem; color: var(--text-secondary);">Download Limit</div>
                        <div style="font-size: 1.25rem; font-weight: 600; margin-top: 0.25rem;">
                            <?= number_format($userData['download_limit'] ?? 0) ?> Files
                        </div>
                    </div>

                </div>
            </div>

            <div class="card" style="margin-top: 2rem;">
                <h3><i data-feather="calculator"
                        style="width: 20px; vertical-align: middle; margin-right: 0.5rem; color: var(--accent-primary);"></i>
                    Monthly Cost Calculator</h3>
                <p class="text-muted" style="margin-bottom: 2rem;">Estimate your monthly costs based on your usage
                    needs.</p>

                <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 3rem; align-items: start;">

                    <!-- Sliders -->
                    <div style="display: flex; flex-direction: column; gap: 2rem;">

                        <!-- Storage Slider -->
                        <div>
                            <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                                <label>Storage Needed</label>
                                <span style="font-weight: 600; color: var(--accent-primary);"><span
                                        id="valStorage">10</span> GB</span>
                            </div>
                            <input type="range" id="rngStorage" min="1" max="1000" step="1" value="10" oninput="calc()"
                                style="width: 100%;">
                            <div style="font-size: 0.8rem; color: var(--text-secondary); margin-top: 0.25rem;">1 ₺ / GB
                                / Month</div>
                        </div>

                        <!-- Upload Slider -->
                        <div>
                            <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                                <label>Upload Requests</label>
                                <span style="font-weight: 600; color: #d946ef;"><span id="valUpload">1000</span></span>
                            </div>
                            <input type="range" id="rngUpload" min="1000" max="100000" step="1000" value="1000"
                                oninput="calc()" style="width: 100%;">
                            <div style="font-size: 0.8rem; color: var(--text-secondary); margin-top: 0.25rem;">0.50 ₺ /
                                1000 Requests</div>
                        </div>

                        <!-- Download Slider -->
                        <div>
                            <div style="display: flex; justify-content: space-between; margin-bottom: 0.5rem;">
                                <label>Download Requests</label>
                                <span style="font-weight: 600; color: #f97316;"><span
                                        id="valDownload">5000</span></span>
                            </div>
                            <input type="range" id="rngDownload" min="1000" max="100000" step="1000" value="5000"
                                oninput="calc()" style="width: 100%;">
                            <div style="font-size: 0.8rem; color: var(--text-secondary); margin-top: 0.25rem;">0.10 ₺ /
                                1000 Requests</div>
                        </div>

                    </div>

                    <!-- Result Box -->
                    <div
                        style="background: rgba(255,255,255,0.05); padding: 2rem; border-radius: 16px; text-align: center; height: 100%; display: flex; flex-direction: column; justify-content: center;">
                        <div style="font-size: 1rem; color: var(--text-secondary); margin-bottom: 1rem;">Estimated
                            Monthly Cost</div>
                        <div style="font-size: 3.5rem; font-weight: 700; color: white; margin-bottom: 0.5rem;">
                            ₺<span id="totalCost">0</span>
                        </div>
                        <div style="font-size: 0.9rem; color: var(--text-secondary);">Excludes taxes & fees</div>

                        <button class="secondary" style="margin-top: 2rem;">Contact Sales for Custom Plan</button>
                    </div>

                </div>
            </div>

            <script>
                function calc() {
                    const storage = parseInt(document.getElementById('rngStorage').value);
                    const upload = parseInt(document.getElementById('rngUpload').value);
                    const download = parseInt(document.getElementById('rngDownload').value);

                    document.getElementById('valStorage').innerText = storage;
                    document.getElementById('valUpload').innerText = upload.toLocaleString();
                    document.getElementById('valDownload').innerText = download.toLocaleString();

                    // Price Logic
                    // 1 TL / GB
                    // 0.50 TL / 1000 Uploads
                    // 0.10 TL / 1000 Downloads

                    const costStorage = storage * 1.0;
                    const costUpload = (upload / 1000) * 0.50;
                    const costDownload = (download / 1000) * 0.10;

                    const total = costStorage + costUpload + costDownload;

                    document.getElementById('totalCost').innerText = total.toFixed(2);
                }

                // Init
                calc();
            </script>
        </div>
    </div>
    <script>feather.replace();</script>
</body>

</html>