<?php
require_once __DIR__ . '/DB.php';

class Share
{
    private $db;

    public function __construct()
    {
        $this->db = new DB(__DIR__ . '/../data/shares.json');
    }

    public function createShare($filePath, $owner, $type = 'link')
    {
        $token = bin2hex(random_bytes(16));
        $data = [
            'file_path' => $filePath,
            'owner' => $owner,
            'type' => $type,
            'created_at' => time(),
            'downloads' => 0
        ];
        $this->db->set($token, $data);
        return $token;
    }

    public function getShare($token)
    {
        return $this->db->get($token);
    }

    public function deleteShare($token)
    {
        $this->db->delete($token);
    }

    public function deleteShareByPath($filePath)
    {
        $all = $this->db->getAll();
        foreach ($all as $token => $data) {
            if (isset($data['file_path']) && $data['file_path'] === $filePath) {
                $this->db->delete($token);
            }
        }
    }

    public function getPublicShares()
    {
        $all = $this->db->getAll();
        $public = [];
        foreach ($all as $token => $data) {
            if (isset($data['type']) && $data['type'] === 'public') {
                $public[$token] = $data;
            }
        }
        return $public;
    }

    public function incrementDownloads($token)
    {
        $data = $this->db->get($token);
        if ($data) {
            $data['downloads'] = ($data['downloads'] ?? 0) + 1;
            $this->db->set($token, $data);
        }
    }
}
