<?php
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<div class="sidebar">
    <div class="brand-title">
        <i data-feather="cloud" style="color: var(--accent-primary)"></i> TurBay Cloud
    </div>

    <nav style="flex:1">
        <?php if (isset($currentUser) && $currentUser): ?>
            <a href="index.php" class="nav-item <?= $currentPage === 'index.php' ? 'active' : '' ?>">
                <i data-feather="hard-drive"></i> Files
            </a>
            <a href="usage.php" class="nav-item <?= $currentPage === 'usage.php' ? 'active' : '' ?>">
                <i data-feather="pie-chart"></i> Usage
            </a>
            <a href="billing.php" class="nav-item <?= $currentPage === 'billing.php' ? 'active' : '' ?>">
                <i data-feather="credit-card"></i> Billing & Packet
            </a>
        <?php endif; ?>

        <a href="discover.php" class="nav-item <?= $currentPage === 'discover.php' ? 'active' : '' ?>">
            <i data-feather="globe"></i> Discover
        </a>

        <?php if (!isset($currentUser) || !$currentUser): ?>
            <a href="login.php" class="nav-item <?= $currentPage === 'login.php' ? 'active' : '' ?>">
                <i data-feather="log-in"></i> Login
            </a>
        <?php endif; ?>
    </nav>

    <?php if (isset($currentUser) && $currentUser && isset($userData)): ?>
        <div style="border-top: 1px solid rgba(255,255,255,0.05); padding-top: 1.5rem;">
            <div
                style="font-size: 0.9rem; font-weight: 500; margin-bottom: 0.5rem; display: flex; justify-content: space-between;">
                <span>Storage</span>
                <span class="text-muted">
                    <?= round(($userData['used_storage'] ?? 0) / 1024 / 1024 / 1024, 2) ?> GB
                </span>
            </div>
            <div class="progress-bar" style="margin-bottom: 1.5rem;">
                <?php
                $limit = $userData['storage_limit'] ?? 0;
                $used = $userData['used_storage'] ?? 0;
                $pct = ($limit > 0) ? ($used / $limit) * 100 : 0;
                ?>
                <div class="progress-fill" style="width: <?= min(100, $pct) ?>%;"></div>
            </div>

            <a href="logout.php" class="nav-item text-muted">
                <i data-feather="log-out"></i> Logout
            </a>
        </div>
    <?php endif; ?>
</div>